<?php

namespace Tickera\Ticket\Element;

if ( class_exists( '\Tickera\TC_Ticket_Template_Elements' ) ) {

    class tc_ticket_type_element_custom extends \Tickera\TC_Ticket_Template_Elements {

        var $element_name = 'tc_ticket_type_element_custom';
        var $element_title = 'Ticket Type (Custom)';
        var $font_awesome_icon = '<i class="fa fa-ticket"></i>';

        function on_creation() {
            $this->element_title = apply_filters('tc_ticket_type_element_title', __('Ticket Type (Custom)', 'tc'));
        }

        function is_3_0_version($version = '3.0') {

            global $woocommerce;
            if (version_compare($woocommerce->version, $version, ">=")) {
                return true;
            }
            return false;
        }

        function ticket_content($ticket_instance_id = false, $ticket_type_id = false) {
            if ($ticket_instance_id) {
                $ticket_instance = new \Tickera\TC_Ticket((int) $ticket_instance_id);
                //$ticket = new TC_Ticket($ticket_instance->details->ticket_type_id);

                if (get_post_type($ticket_instance->details->ticket_type_id) == 'product_variation') {
                    $variation = wc_get_product($ticket_instance->details->ticket_type_id);
                    //var_dump($variation);
                    $title = $variation->get_title();

                    if (!$this->is_3_0_version()) {
                        $variation_data = wc_get_formatted_variation($variation->variation_data, true);
                    } else {// different args to reflect WooCommerce 3.0 changes
                        $variation_data = wc_get_formatted_variation($variation, true, false);
                    }
                    if (isset($variation_data)) {
                        $title = $variation_data;
                    }
                } else {
                    $title = get_the_title($ticket_instance->details->ticket_type_id);
                }

                return $title;
            } else {
                if ($ticket_type_id) {
                    $ticket_type = new \Tickera\TC_Ticket((int) $ticket_type_id);
                    return apply_filters('tc_ticket_type_element', $ticket_type->details->post_title);
                } else {
                    return apply_filters('tc_ticket_type_element_default', __('VIP Ticket', 'tc'));
                }
            }
        }
    }

    \Tickera\tickera_register_template_element( 'Tickera\Ticket\Element\tc_ticket_type_element_custom', __('Ticket Type (Custom)', 'tc'));
}