<?php

namespace Tickera\Ticket\Element;

if ( class_exists( '\Tickera\TC_Ticket_Template_Elements' ) ) {

    class tc_woo_basic_price_element extends \Tickera\TC_Ticket_Template_Elements {

        var $element_name = 'tc_woo_basic_price_element';
        var $element_title = 'Ticket Base Price (WooCommerce)';
        var $font_awesome_icon = '<i class="fa fa-usd"></i>';

        function on_creation() {
            $this->element_title = apply_filters( 'tc_woo_basic_price_title', __( 'Ticket Base Price', 'tc' ) );
        }

        function ticket_content( $ticket_instance_id = false, $ticket_type_id = false ) {

            if ( $ticket_instance_id ) {
                $ticket_instance = new \Tickera\TC_Ticket_Instance( (int) $ticket_instance_id );
                $product_id = get_post_meta( $ticket_instance_id, 'ticket_type_id', true );
                $_product = wc_get_product( $product_id );
                $ticket_price = wc_price( $_product->get_price() );
                return apply_filters( 'tc_woo_basic_price_element', $ticket_price );

            } else {
                return apply_filters( 'tc_ticket_ticket_basic_price_element_default', __( '$10 (example value)', 'tc' ) );
            }
        }
    }

    \Tickera\tickera_register_template_element( 'Tickera\Ticket\Element\tc_woo_basic_price_element', __( 'Ticket Base Price', 'tc' ) );
}
