<?php

namespace Tickera\Ticket\Element;

if ( class_exists( '\Tickera\TC_Ticket_Template_Elements' ) ) {

    class tc_basic_price_element extends \Tickera\TC_Ticket_Template_Elements {

        var $element_name		 = 'tc_basic_price_element';
        var $element_title		 = 'Ticket Base Price';
        var $font_awesome_icon	 = '<i class="fa fa-usd"></i>';

        function on_creation() {
            $this->element_title = apply_filters( 'tc_basic_price_title', __( 'Ticket Base Price', 'tc' ) );
        }

        function ticket_content( $ticket_instance_id = false, $ticket_type_id = false) {
            global $tc;
            if ( $ticket_instance_id ) {
                $ticket_instance = new \Tickera\TC_Ticket( (int) $ticket_instance_id );
                $ticket			 = new \Tickera\TC_Ticket( apply_filters( 'tc_ticket_type_id', $ticket_instance->details->ticket_type_id ) );
                $ticket_price = apply_filters( 'tc_ticket_ticket_basic_price_element', apply_filters( 'tc_the_price', $ticket->details->price_per_ticket ) );
                $price_currency = $tc->get_cart_currency_and_format($ticket_price);
                return 'Price: '.$price_currency;

            } else {
                return apply_filters( 'tc_ticket_ticket_basic_price_element_default', __( '$10 (example value)', 'tc' ) );
            }
        }
    }

    \Tickera\tickera_register_template_element( 'Tickera\Ticket\Element\tc_basic_price_element', __( 'Ticket Base Price', 'tc' ) );
}















