<?php
/**
 * Plugin Name: Tickera - Ticket Base Price Element
 * Plugin URI: http://tickera.com/
 * Description: Adds ticket base price ticket template element
 * Author: Tickera.com
 * Author URI: http://tickera.com/
 * Version: 1.2
 * TextDomain: tc
 * Domain Path: /languages/
 * Copyright 2016 Tickera (http://tickera.com/)
 */
if ( !defined( 'ABSPATH' ) )
    exit; // Exit if accessed directly


if ( !class_exists( 'TC_base_price_element' ) ) {

    class TC_base_price_element {

        var $version = '1.2';
        var $title = 'Ticket Base Price Ticket Template Element';
        var $name = 'ticket-base-price-ticket-template-element';
        var $dir_name = 'ticket-base-price-element';
        var $location = 'plugins';
        var $plugin_dir = '';
        var $plugin_url = '';

        function __construct() {
            $this->init_vars();
            add_action( 'activated_plugin', array( $this, 'plugin_dependencies' ), 99 );
            add_action( 'tc_load_ticket_template_elements', array( $this, 'load_ticket_template_elements' ) );
        }

        function init_vars() {

            if ( defined( 'WP_PLUGIN_URL' ) && defined( 'WP_PLUGIN_DIR' ) && file_exists( WP_PLUGIN_DIR . '/' . $this->dir_name . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'subfolder-plugins';
                $this->plugin_dir = WP_PLUGIN_DIR . '/' . $this->dir_name . '/';
                $this->plugin_url = plugins_url( '/', __FILE__ );

            } elseif ( defined( 'WP_PLUGIN_URL' ) && defined( 'WP_PLUGIN_DIR' ) && file_exists( WP_PLUGIN_DIR . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'plugins';
                $this->plugin_dir = WP_PLUGIN_DIR . '/';
                $this->plugin_url = plugins_url( '/', __FILE__ );

            } elseif ( is_multisite() && defined( 'WPMU_PLUGIN_URL' ) && defined( 'WPMU_PLUGIN_DIR' ) && file_exists( WPMU_PLUGIN_DIR . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'mu-plugins';
                $this->plugin_dir = WPMU_PLUGIN_DIR;
                $this->plugin_url = WPMU_PLUGIN_URL;

            } else {
                wp_die( sprintf( __( 'There was an issue determining where %s is installed. Please reinstall it.', 'tc' ), $this->title ) );
            }
        }

        /**
         * Load this plugin the very last to ensure all the dependencies loaded first.
         */
        function plugin_dependencies() {

            $plugin_slug = basename( __DIR__ ) . '/' . basename( __FILE__ );
            $active_plugins = get_option( 'active_plugins', [] );
            $index = array_search( $plugin_slug, $active_plugins );

            if ( $index !== false ) {
                unset( $active_plugins[ $index ] );
                $active_plugins[] = $plugin_slug;
                update_option( 'active_plugins', array_values( $active_plugins ) );
            }
        }

        function load_ticket_template_elements() {

            $dir = $this->plugin_dir . 'ticket-elements/';
            $ticket_template_elements = array();

            if ( !is_dir( $dir ) )
                return;

            if ( !$dh = opendir( $dir ) )
                return;

            while ( ( $plugin = readdir( $dh ) ) !== false ) {

                if ( substr( $plugin, -4 ) == '.php' )
                    $ticket_template_elements[] = $dir . '/' . $plugin;
            }

            closedir( $dh );
            sort( $ticket_template_elements );

            foreach ( $ticket_template_elements as $file )
                include( $file );


            do_action( 'tc_load_base_price_ticket_template_element' );
        }
    }

    $TC_base_price_element = new TC_base_price_element();
}

