<?php
/**
 * Render Events Drop Down
 *
 * @param string $field_name
 * @param string $post_id
 * @param bool $multi_select
 */
function tc_get_resend_email_events( $field_name = '', $post_id = '', $multi_select = false ) {

    $placeholder = ( $multi_select ) ? __( 'Choose any events', 'tcrbae' ) : '';

    $tc_email_settings = get_option('tickera_email_setting', false);
    $selected = ( isset( $tc_email_settings['resend_attendees_event_name'] ) ) ? $tc_email_settings['resend_attendees_event_name'] : 'all';

    $wp_events_search = new Tickera\TC_Events_Search( '', '', -1 );
    ?>

    <!-- Event Name Field -->
    <select id="resend_attendees_event_name" class="regular-text dynamic-field-child" name="tickera_email_setting[resend_attendees_event_name]" data-placeholder="<?php echo $placeholder; ?>">
        <?php foreach ( $wp_events_search->get_results() as $event ) : ?>
            <option value="<?php echo (int) $event->ID; ?>" <?php selected( $event->ID, $selected, true ); ?>><?php echo get_the_title( (int) $event->ID ); ?></option>
         <?php endforeach; ?>
    </select>
    <?php
}

function tc_get_resend_email_types( $field_name = '', $post_id = '' ) {
    $tc_email_settings = get_option('tickera_email_setting', false);
    $selected = $tc_email_settings[ 'resend_attendees_email_types' ] ?? 'buyers';
    ?>
    <label>
        <input type="radio" class="<?php echo esc_attr( $field_name ); ?>" name="tickera_email_setting[resend_attendees_email_types]" value="buyers" <?php checked( $selected, 'buyers', true ); ?>>
        <span>Buyers</span>
    </label>
    <br>
    <label>
        <input type="radio" class="<?php echo esc_attr( $field_name ); ?>" name="tickera_email_setting[resend_attendees_email_types]" value="attendees" <?php checked( $selected, 'attendees', true ); ?>>
        <span>Attendees</span>
    </label>
    <?php
}

function tc_render_event_table( $event ) {

    if ( ! $event ) {
        return false;
    }

    ob_start();
    ?>
    <table style="border:1px solid #dcd7ca; border-collapse: collapse; border-spacing: 0; empty-cells: show;">
        <tbody>
        <tr>
            <?php foreach ( (array) $event[ 'ticket_data' ][0] as $key => $ticket_datum ) : ?>
                <th style="border:1px solid #dcd7ca; padding: 0.5em 2em; text-align: left;"><?php echo __( ucwords( str_replace( '_', ' ', $key ) ), 'tcrbae' ); ?></th>
            <?php endforeach; ?>
        </tr>
        <?php foreach ( $event[ 'ticket_data' ] as $ticket_data ) : ?>
            <tr>
                <?php foreach ( $ticket_data as $datum ) : ?>
                    <td style="border:1px solid #dcd7ca; padding: 0.5em 2em; text-align: left;"><?php echo wp_kses_post( $datum ); ?></td>
                <?php endforeach; ?>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
    <?php
    return ob_get_clean();
}
