( function( $ ) {

    $( document ).on( 'ready', function() {

        // Update content description
        let description = $( '.resend_event_type:checked' ).val();
        description = ( 'buyers' == description ) ? tc_email_vars.buyers_description : tc_email_vars.attendees_description;
        $( '#resend_attendee_order_email_content_holder .description' ).html( description )

        // Loading icon and messages
        let txtarea = $( '#resend_attendee_order_email_content' ).val(),
            btn = '<div class="tc_email_container">' +
                '<span class="tc_email_sent"></span>' +
                '<img class="tc-loading" style="display:none;" src="' + tc_email_vars.loadingIcon + '"/>' +
                '<button class="tc_tc_resend_order_email button button-primary" id="tc_resend_order_email" style="float:none;">Send Email</button>' +
                '</div>';

        if ( txtarea )
            $( '#resend_attendee_order_email_content_holder td' ).append( btn );
    } );

    $( document ).on( 'click', '#tc_resend_order_email', function( event ) {

        event.preventDefault();
        tcre.render_log_panel();

        let answer = confirm( tc_email_vars.before_send_message );

        if ( answer ) {

            $( '.tc-loading' ).show();
            $( '#tc_resend_order_email' ).hide();
            $( '.tc_email_sent' ).hide();

            $.post( tc_email_vars.ajaxUrl, {
                    action: "tc_resend_attendees_order_emails",
                    event_id: $( '#resend_attendees_event_name' ).val(),
                    send_to: $( '.resend_event_type:checked' ).val()
                }, function( data ) {
                    $( '.tc-loading' ).hide();
                    $( '#tc_resend_order_email' ).show();

                    if ( typeof data !== 'undefined' ) {

                        // Email Sent Count
                        $( '.tc_email_sent' ).html( data.count + ' ' + tc_email_vars.email_sent ).css( 'display', 'block' );
                        tcre.render_log_panel( data.sent_emails );
                    }
                }
            );
        }
    } );

    $( document ).on( 'change', '.resend_event_type', function() {
        let description = ( 'buyers' == $( this ).val() ) ? tc_email_vars.buyers_description : tc_email_vars.attendees_description;
        $( '#resend_attendee_order_email_content_holder .description' ).html( description )
    } );

    const tcre = {

        render_log_panel: function( emails ) {

            $( '#tcre_log_panel_container' ).remove();

            if ( ! emails ) {
                return false;
            }

            let panel = '<div id="tcre_log_panel_container"><span>' + tc_email_vars.report_log_panel_header + '</span><textarea id="tcre_log_panel" rows="10" readonly></textarea></div>',
                value = emails.join( '\n' );

            $( '.tc_email_container' ).prepend( panel );
            $( '#tcre_log_panel' ).append( value );
        }
    };

} )( jQuery );
