<?php
/**
 * Plugin Name: Tickera - Frontend Event Table Quantity Option
 * Plugin URI: https://tickera.com
 * Description: Unofficial add-on: Allow Quantity Option in the Frontend Event Table
 * Author: Tickera.com
 * Author URI: http://tickera.com/
 * Version: 1.3
 * Copyright 2017 Tickera (http://tickera.com/)
 */

if ( !class_exists( 'TC_Event_Table_Quantity_Option' ) ) {

    class TC_Event_Table_Quantity_Option {

        var $version = '1.3';
        var $title = 'Tickera - Frontend Event Table Quantity Option';
        var $name = 'tc-event-table-qty-option';
        var $dir_name = 'tc-event-table-qty-option';
        var $location = 'plugins';
        var $plugin_dir = '';
        var $plugin_url = '';

        function __construct() {

            self::init_vars();
            add_action( 'activated_plugin', array( $this, 'plugin_dependencies' ), 99 );

            if ( class_exists( 'TC_WooCommerce_Bridge' ) ) {

                add_action( 'wp_enqueue_scripts', array( $this, 'tc_enqueue_scripts' ) );

                // Additional Event Table Columns for quantity
                add_action( 'tc_wb_event_col_title_before_cart_title', array( $this, 'wb_quantity_option_column_title' ) );
                add_action( 'tc_wb_event_col_value_before_cart_title', array( $this, 'wb_quantity_option_selector' ) );

                // Add to cart Ajax
                add_action( 'wp_ajax_tcetqo_custom_add_to_cart', array( $this, 'tcetqo_custom_add_to_cart' ) );
                add_action( 'wp_ajax_nopriv_tcetqo_custom_add_to_cart', array( $this, 'tcetqo_custom_add_to_cart' ) );

            } else {
                add_filter( 'tc_event_shortcode', array( $this, 'tc_enable_quantity_option' ) );
            }
        }

        function init_vars() {

            if ( defined( 'WP_PLUGIN_URL' ) && defined( 'WP_PLUGIN_DIR' ) && file_exists( WP_PLUGIN_DIR . '/' . $this->dir_name . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'subfolder-plugins';
                $this->plugin_dir = WP_PLUGIN_DIR . '/' . $this->dir_name . '/';
                $this->plugin_url = plugins_url( '/', __FILE__ );

            } elseif ( defined( 'WP_PLUGIN_URL' ) && defined( 'WP_PLUGIN_DIR' ) && file_exists( WP_PLUGIN_DIR . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'plugins';
                $this->plugin_dir = WP_PLUGIN_DIR . '/';
                $this->plugin_url = plugins_url( '/', __FILE__ );

            } elseif ( is_multisite() && defined( 'WPMU_PLUGIN_URL' ) && defined( 'WPMU_PLUGIN_DIR' ) && file_exists( WPMU_PLUGIN_DIR . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'mu-plugins';
                $this->plugin_dir = WPMU_PLUGIN_DIR;
                $this->plugin_url = WPMU_PLUGIN_URL;

            } else {
                wp_die( sprintf( __( 'There was an issue determining where %s is installed. Please reinstall it.', 'tc' ), $this->title ) );
            }
        }

        /**
         * Load this plugin the very last to ensure all the dependencies loaded first.
         */
        function plugin_dependencies() {

            $plugin_slug = basename( __DIR__ ) . '/' . basename( __FILE__ );
            $active_plugins = get_option( 'active_plugins', [] );
            $index = array_search( $plugin_slug, $active_plugins );

            if ( $index !== false ) {
                unset( $active_plugins[ $index ] );
                $active_plugins[] = $plugin_slug;
                update_option( 'active_plugins', array_values( $active_plugins ) );
            }
        }

        /**
         * Load Assets
         */
        function tc_enqueue_scripts() {
            wp_enqueue_style( $this->name, plugin_dir_url( __FILE__ ) . 'assets/css/' . $this->name . '.css', array(), $this->version );
            wp_enqueue_script( $this->name, plugin_dir_url( __FILE__ ) . 'assets/js/' . $this->name . '.js', array( 'jquery' ), $this->version, true );
            wp_localize_script( $this->name, 'tcetqo_ajax', array(
                'ajaxUrl' => apply_filters( 'tc_ajaxurl', admin_url( 'admin-ajax.php', ( is_ssl() ? 'https' : 'http' ) ) ),
                'cart_page' => wc_get_cart_url(),
                'add_to_cart_ajax' => get_option( 'woocommerce_enable_ajax_add_to_cart' ) ? get_option( 'woocommerce_enable_ajax_add_to_cart' ) : 'no',
                'redirect_to_cart' => get_option( 'woocommerce_cart_redirect_after_add' ) ? get_option( 'woocommerce_cart_redirect_after_add' ) : 'no',
                'view_cart_text' => __( 'View cart', 'tc' )
            ) );
        }

        /**
         * Enable quantity select field in Tickera Standalone.
         * @return string
         */
        function tc_enable_quantity_option() {
            return '[tc_event quantity="true"]';
        }

        /**
         * Render quantity select field column name.
         * Woocommerce and Bridge for Woocommerce
         */
        function wb_quantity_option_column_title() {
            echo '<th>' . __( 'Qty.', 'tc' ) . '</th>';
        }

        /**
         * Map quantity field to add to cart button.
         * Woocommerce and Bridge for Woocommerce
         *
         * @param $ticket_type_id
         */
        function wb_quantity_option_selector( $ticket_type_id ) {
            echo '<td>' . self::wb_quantity_selector( $ticket_type_id ) . '</td>';
            echo '<td>' . do_shortcode( '[add_to_cart id="' . $ticket_type_id . '" quantity="1" style="" show_price="false"]' ) . '</td>';
        }

        /**
         * Render select quantity field.
         * Woocommerce and Bridge for Woocommerce
         *
         * @param $ticket_type_id
         * @return string
         */
        function wb_quantity_selector( $ticket_type_id ) {

            $max_quantity = apply_filters( 'tc_modify_wb_max_quantity_selector_value', 25 );

            $product = wc_get_product( $ticket_type_id );
            $manage_stock = $product->get_manage_stock();
            $stock_status = $product->get_stock_status();

            if ( $manage_stock ) {
                $quantity = ( $product->get_stock_quantity() > $max_quantity ) ? $max_quantity : $product->get_stock_quantity();

            } else {
                $quantity = ( 'instock' == $stock_status ) ? $max_quantity : 0;
            }

            $select = '<select class="wb_quantity_selector">';

            if ( $quantity ) {

                for ( $i = 1; $i <= $quantity; $i++ ) {
                    $select .= '<option value="' . $i . '">';
                    $select .= $i;
                    $select .= '</option>';
                }

            } else {
                $select .= '<option value="0">0</option>';
            }

            return $select;
        }

        /**
         * Process add to cart ajax.
         * Woocommerce and Bridge for Woocommerce
         *
         * @throws Exception
         */
        function tcetqo_custom_add_to_cart() {

            if ( 'tcetqo_custom_add_to_cart' == $_POST[ 'action' ] ) {

                $quantity = $_POST[ 'quantity_selected' ] ?? 0;
                $product_id = $_POST[ 'ticket_type_id' ] ?? false;

                if ( $product_id ) {
                    $added_to_cart = WC()->cart->add_to_cart( (int)$product_id, (int)$quantity );

                    if ( $added_to_cart ) {
                        wp_send_json( [ 'status' => 'added_to_cart' ] );
                    }
                }
            }
        }
    }

    $TC_Event_Table_Quantity_Option = new TC_Event_Table_Quantity_Option();
}
