( function ( $ ) {

    $( document ).on( 'change', '.wb_quantity_selector', function() {
        let quantity_selected = $( this ).val();
        $( this ).closest( 'tr' ).find( '.add_to_cart_button' ).attr( 'data-quantity', quantity_selected );
    });

    $( document ).on( 'click', '.event_tickets.tickera .add_to_cart_button', function( e ) {

        e.preventDefault();

        let button = $( this ),
            quantity_selected = button.attr( 'data-quantity' ),
            product_id = button.attr( 'data-product_id' );

        // Clear appended elements
        button.siblings( '.added_to_cart.wc-forward' ).remove();

        $.post( tcetqo_ajax.ajaxUrl, {
            action: 'tcetqo_custom_add_to_cart',
            quantity_selected: quantity_selected,
            ticket_type_id: product_id

        }, function ( response ) {

            if ( typeof response !== 'undefined' ) {
                $( document.body ).trigger( 'wc_fragment_refresh' );

                if ( 'yes' == tcetqo_ajax.redirect_to_cart ) {
                    window.location.href = tcetqo_ajax.cart_page;

                } else if ( 'no' == tcetqo_ajax.add_to_cart_ajax ) {
                    button.after( '<a href="' + tcetqo_ajax.cart_page + '" class="added_to_cart wc-forward" title="' + tcetqo_ajax.view_cart_text + '">' + tcetqo_ajax.view_cart_text + '</a>' );
                }
            }
        });
    });

})( jQuery );
