<?php
/**
 * Plugin Name: Tickera - Custom force login URL
 * Plugin URI: https://tickera.com
 * Description: Set custom force login URL
 * Author: Tickera
 * Author URI: https://tickera.com
 * Version: 1.1
 * Text Domain: tc_cflu
 * Domain Path: /languages/
 * Copyright 2018 Tickera (https://tickera.com)
 */

if ( !defined( 'ABSPATH' ) )
    exit; // Exit if accessed directly

if ( !class_exists( 'TC_tc_custom_force_login_url_addon' ) ) {

    class TC_tc_custom_force_login_url_addon {

        var $version = '1.1';
        var $title = 'Tickera - Custom force login URL';
        var $name = 'tc_custom_force_login_url_addon';
        var $dir_name = 'tc-custom-force-login-url-addon';
        var $location = 'plugins';
        var $plugin_dir = '';
        var $plugin_url = '';

        function __construct() {

            $this->init_vars();
            add_action( 'activated_plugin', array( $this, 'plugin_dependencies' ), 99 );

            if ( class_exists( '\Tickera\TC' ) ) { // Check if Tickera plugin is active / main Tickera class exists
                add_filter( 'tc_general_settings_miscellaneous_fields', array( $this, 'tc_general_settings_miscellaneous_fields_add_custom_force_login_url' ) );
                add_filter( 'tc_force_login_url', array( $this, 'tc_custom_force_login_url' ) );
            }
        }

        /**
         * Setup proper directories
         */
        function init_vars() {

            if ( defined( 'WP_PLUGIN_URL' ) && defined( 'WP_PLUGIN_DIR' ) && file_exists( WP_PLUGIN_DIR . '/' . $this->dir_name . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'subfolder-plugins';
                $this->plugin_dir = WP_PLUGIN_DIR . '/' . $this->dir_name . '/';
                $this->plugin_url = plugins_url( '/', __FILE__ );

            } elseif ( defined( 'WP_PLUGIN_URL' ) && defined( 'WP_PLUGIN_DIR' ) && file_exists( WP_PLUGIN_DIR . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'plugins';
                $this->plugin_dir = WP_PLUGIN_DIR . '/';
                $this->plugin_url = plugins_url( '/', __FILE__ );

            } elseif ( is_multisite() && defined( 'WPMU_PLUGIN_URL' ) && defined( 'WPMU_PLUGIN_DIR' ) && file_exists( WPMU_PLUGIN_DIR . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'mu-plugins';
                $this->plugin_dir = WPMU_PLUGIN_DIR;
                $this->plugin_url = WPMU_PLUGIN_URL;

            } else {
                wp_die( sprintf( __( 'There was an issue determining where %s is installed. Please reinstall it.', 'tc_cflu' ), $this->title ) );
            }
        }

        /**
         * Load this plugin the very last to ensure all the dependencies loaded first.
         */
        function plugin_dependencies() {

            $plugin_slug = basename( __DIR__ ) . '/' . basename( __FILE__ );
            $active_plugins = get_option( 'active_plugins', [] );
            $index = array_search( $plugin_slug, $active_plugins );

            if ( $index !== false ) {
                unset( $active_plugins[ $index ] );
                $active_plugins[] = $plugin_slug;
                update_option( 'active_plugins', array_values( $active_plugins ) );
            }
        }

        /**
         * Create new field in the Tickera admin settings under Miscellaneous section
         * @param type $fields
         * @return type
         */
        function tc_general_settings_miscellaneous_fields_add_custom_force_login_url( $fields ) {
            $fields [] = array(
                'field_name' => 'tc_custom_force_login_url',
                'field_title' => __( 'Custom force login URL', 'tc' ),
                'field_type' => 'option',
                'default_value' => '',
                'tooltip' => 'Replaces force login URL. Leave empty in order to use standard WordPress URL.',
                'section' => 'miscellaneous_settings',
            );
            return $fields;
        }

        /**
         * Check if there is a custom force login URL and it's not empty so we can replace it
         * @param type $login_url
         * @return type
         */
        function tc_custom_force_login_url( $login_url ) {

            $tc_general_settings = get_option( 'tickera_general_setting', false );
            $tc_custom_force_login_url = isset( $tc_general_settings[ 'tc_custom_force_login_url' ] ) ? $tc_general_settings[ 'tc_custom_force_login_url' ] : '';

            if ( !empty( $tc_custom_force_login_url ) ) {
                $parts = parse_url( $login_url );
                parse_str( $parts[ 'query' ], $query );
                $redirect_to = $query[ 'redirect_to' ];
                return add_query_arg( 'redirect_to', $redirect_to, $tc_custom_force_login_url );

            } else {
                return $login_url;
            }
        }
    }

    $TC_tc_custom_force_login_url_addon = new TC_tc_custom_force_login_url_addon();
}