<?php
/**
 * Plugin Name: Tickera - Bulk Remove Check-ins per Event
 * Plugin URI: http://tickera.com/
 * Description: Unofficial Add-on: Bulk remove tickets' check-ins per event. Options added in Tickera > Settings.
 * Author: Tickera.com
 * Author URI: http://tickera.com/
 * Version: 2.0
 * TextDomain: tc
 * Domain Path: /languages/
 * Copyright 2018 Tickera (http://tickera.com/)
 */

if ( !defined( 'ABSPATH' ) )
    exit; // Exit if accessed directly

if ( !class_exists( 'TC_Bulk_Remove_Check_Ins_Per_Event' ) ) {

    class TC_Bulk_Remove_Check_Ins_Per_Event {

        var $version = '2.0';
        var $title = 'Tickera - Bulk Remove Check-ins per Event';
        var $name = 'tc-bulk-remove-checkins-per-event';
        var $dir_name = 'tc-bulk-remove-checkins-per-event';
        var $location = 'plugins';
        var $plugin_dir = '';
        var $plugin_url = '';

        function __construct() {
            self::init_vars();
            add_action( 'activated_plugin', array( $this, 'plugin_dependencies' ), 99 );
            add_action( 'admin_enqueue_scripts', array( $this, 'admin_enqueue_scripts' ) );

            add_filter( 'tc_settings_new_menus', array( $this, 'tc_settings_new_menus' ) );
            add_action( 'tc_settings_menu_bulk_remove_checkins', array( $this, 'tc_settings_menu_content' ) );

            add_action( 'wp_ajax_tc_bulk_remove_checkins', array( $this, 'process_checkins_removal' ) );;
        }

        function init_vars() {

            if ( defined( 'WP_PLUGIN_URL' ) && defined( 'WP_PLUGIN_DIR' ) && file_exists( WP_PLUGIN_DIR . '/' . $this->dir_name . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'subfolder-plugins';
                $this->plugin_dir = WP_PLUGIN_DIR . '/' . $this->dir_name . '/';
                $this->plugin_url = plugins_url( '/', __FILE__ );

            } elseif ( defined( 'WP_PLUGIN_URL' ) && defined( 'WP_PLUGIN_DIR' ) && file_exists( WP_PLUGIN_DIR . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'plugins';
                $this->plugin_dir = WP_PLUGIN_DIR . '/';
                $this->plugin_url = plugins_url( '/', __FILE__ );

            } elseif ( is_multisite() && defined( 'WPMU_PLUGIN_URL' ) && defined( 'WPMU_PLUGIN_DIR' ) && file_exists( WPMU_PLUGIN_DIR . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'mu-plugins';
                $this->plugin_dir = WPMU_PLUGIN_DIR;
                $this->plugin_url = WPMU_PLUGIN_URL;

            } else {
                wp_die( sprintf( __( 'There was an issue determining where %s is installed. Please reinstall it.', 'tc' ), $this->title ) );
            }
        }

        /**
         * Load this plugin the very last to ensure all the dependencies loaded first.
         */
        function plugin_dependencies() {

            $plugin_slug = basename( __DIR__ ) . '/' . basename( __FILE__ );
            $active_plugins = get_option( 'active_plugins', [] );
            $index = array_search( $plugin_slug, $active_plugins );

            if ( $index !== false ) {
                unset( $active_plugins[ $index ] );
                $active_plugins[] = $plugin_slug;
                update_option( 'active_plugins', array_values( $active_plugins ) );
            }
        }

        /**
         * Adds new admin menu item for the add-on
         *
         * @param array $menus
         * @return array
         */
        function tc_settings_new_menus( $menus ) {
            $menus[ 'bulk_remove_checkins' ] = __( 'Bulk Remove Checkins', 'tc' );
            return $menus;
        }

        /**
         * Loads admin settings page for the add-on
         */
        function tc_settings_menu_content() {
            include( $this->plugin_dir . 'includes/admin-pages/settings.php' );
        }

        /**
         * Load Assets
         */
        function admin_enqueue_scripts() {
            wp_enqueue_style( $this->name, plugin_dir_url( __FILE__ ) . 'assets/css/admin.css', array(), $this->version );
            wp_enqueue_script( $this->name, plugin_dir_url( __FILE__ ) . 'assets/js/admin.js', array( 'jquery' ), $this->version, true );
            wp_localize_script( $this->name, 'tc_bulk_remove_checkins', array(
                    'ajaxUrl' => apply_filters( 'tc_ajaxurl', admin_url( 'admin-ajax.php', ( is_ssl() ? 'https' : 'http' ) ) ),
                    'confirm_deletion' => __( 'Are you sure you want to delete the events\' tickets check-ins?', 'tc' ),
                    'has_been_removed' => __( 'tickets have been deleted.', 'tc' ),
                    'has_error' => __( 'Something went wrong. Please try again.', 'tc' ),
                    'select_event' => __( 'Please select an event.', 'tc' )
                )
            );
        }

        /**
         * Process Deletion of Tickets base from the selected type
         */
        function process_checkins_removal() {

            $page = isset( $_POST[ 'page' ] ) ? (int) $_POST[ 'page' ] : 1;
            $post_per_page = 100;

            $date_from = isset( $_POST[ 'date_from' ] ) ? $_POST[ 'date_from' ] : false;
            $date_to = isset( $_POST[ 'date_to' ] ) ? $_POST[ 'date_to' ] : false;

            $events_ids = isset( $_POST[ 'event_ids' ] ) ? $_POST[ 'event_ids' ] : [];
            $deleted = isset( $_POST[ 'deleted' ] ) ? (int) $_POST[ 'deleted' ] : 0;

            if ( $events_ids ) {

                // Collection of Attendee's Tickets
                $args = [
                    'post_type' => 'tc_tickets_instances',
                    'post_status' => 'any',
                    'meta_query' => [
                        'relation' => 'AND',
                        [ 'key' => 'event_id', 'value' => $events_ids, 'compare' => 'IN' ]
                    ],
                    'fields' => 'ids',
                    'paged' => $page,
                    'posts_per_page' => $post_per_page,
                ];

                if ( $date_from && $date_to ) {
                    $args[ 'date_query' ] = [
                        [
                            'after' => $date_from,
                            'before' => $date_to,
                            'inclusive' => true
                        ]
                    ];
                }

                $ticket_instances = new WP_Query( $args );
                while ( $ticket_instances->have_posts() ) {

                    $ticket_instances->the_post();
                    $ticket_instance_id = get_the_ID();
                    $checkins = get_post_meta( $ticket_instance_id, 'tc_checkins', true );


                    if ( $checkins ) {
                        update_post_meta( $ticket_instance_id, 'tc_checkins', [] );
                        update_post_meta( $ticket_instance_id, 'tc_checkouts', [] );
                        $deleted++;
                    }
                }
                wp_reset_postdata();

                wp_send_json( [
                    'page' => ( $page + 1 ),
                    'max_page' => $ticket_instances->max_num_pages,
                    'deleted' => $deleted,
                    'completed' => ( $page >= $ticket_instances->max_num_pages ) ? true : false
                ]);
            }
        }
    }

    $TC_Bulk_Remove_Check_Ins_Per_Event = new TC_Bulk_Remove_Check_Ins_Per_Event();
}

