<?php
global $wp_rewrite;

if ( isset( $_POST[ 'save_tc_bulk_remove_checkins_settings' ] ) ) {

    if ( check_admin_referer( 'save_tc_bulk_remove_checkins_settings' ) ) {

        if ( current_user_can( 'manage_options' ) || current_user_can( 'save_settings_cap' ) ) {
            update_option( 'tc_bulk_remove_checkins', tickera_sanitize_array( $_POST[ 'tc_bulk_remove_checkins' ], true ) );
            $wp_rewrite->flush_rules();
            $message = __( 'Settings data has been successfully saved.', 'tickera-event-ticketing-system' );

        } else {
            $message = __( 'You do not have required permissions for this action.', 'tickera-event-ticketing-system' );
        }
    }
}

$settings = get_option( 'tc_bulk_remove_checkins', [] );
$cron_enabled = isset( $settings[ 'cron_enable' ] ) ? $settings[ 'cron_enable' ] : 'no';
$cron_frequency = isset( $settings[ 'cron_frequency' ] ) ? $settings[ 'cron_frequency' ] : 'hourly';
?>
<div class="wrap tc_wrap tc-dl-wrapper">
    <div id="poststuff" class="metabox-holder">
        <div class="postbox">
            <h3>
                <span><?php _e('Bulk Remove Checkins', 'tc'); ?></span>
                <span class="description"><?php _e( 'Please note that this action is irreversible. Please secure a database backup prior to processing of checkins removal.', 'tc' ); ?></span>
            </h3>
            <div class="inside">
                <table class="form-table">
                    <tbody>
                    <tr id="tc_bulk_remove_checkins_event_filter">
                        <th scope="row"><label><?php _e('Events', 'tc') ?></label></th>
                        <td>
                            <div class="tc-dl-inner-container">
                                <?php $wp_events_search = new Tickera\TC_Events_Search( '', '', -1 ); ?>
                                <select name="event_ids" class="regular-text" data-placeholder="<?php _e( 'Select some events to delete all associated tickets' ,'tc' ); ?>" multiple="true">
                                    <?php foreach ( $wp_events_search->get_results() as $event ) :
                                        $event = new Tickera\TC_Event( $event->ID );
                                        $event_date = $event->get_event_date();
                                        ?>
                                        <option value="<?php echo esc_attr( $event->details->ID ); ?>"><?php echo esc_html( $event->details->post_title . ' (' . $event_date . ')' ); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </td>
                    </tr>
                    <tr id="tc_bulk_remove_checkins_date_filter">
                        <th scope="row">
                            <label><?php _e('Date range:', 'tc') ?></label>
                            <p><?php _e( 'Select the date range for tickets you want to delete based on the order creation date.', 'tc' ); ?></p>
                        </th>
                        <td>
                            <label>From</label>
                            <br>
                            <input type="text" class="tc_date_field" name="tickets_created_date_range_from" value=""/>
                        </td>
                        <td>
                            <label>To</label>
                            <br>
                            <input type="text" class="tc_date_field" name="tickets_created_date_range_to" value=""/>
                        </td>
                    </tr>
                    <tr class="tc-dl-no-border">
                        <th scope="row">
                            <span class="tc_bulk_delete_checkins_notice"></span>
                            <div class="tccrr-loader hidden"><div></div><div></div><div></div><div></div></div><!-- Spinner -->
                        </th>
                    </tr>
                    <tr class="tc-dl-no-border">
                        <th scope="row">
                            <input type="button" id="tc_bulk_remove_checkins_btn" class="button button-primary" value="<?php _e( 'Delete', 'tc' ); ?>"/>
                        </th>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>