( function ( $ ) {

    $( document ).ready( function() {

        $( '#tc_bulk_remove_checkins_date_filter input[type="text"]' ).appendDtpicker( {
            "inline": false,
            "minuteInterval": 15,
            "futureOnly": false,
            "todayButton": true
        } );
    });

    $('#tc_bulk_remove_checkins_btn').on( 'click', function() {

        if ( ! $('#tc_bulk_remove_checkins_event_filter select').chosen().val().length ) {
            alert( tc_bulk_remove_checkins.select_event );

        } else {

            let tcConfirm = confirm( tc_bulk_remove_checkins.confirm_deletion );

            if ( tcConfirm ) {
                $( this ).prop( 'disabled', true );

                $( '.tc_bulk_delete_checkins_notice' ).empty().addClass( 'tc-dl-notice' ).html( 0 + ' ' + tc_bulk_remove_checkins.has_been_removed + '<br>' + 1 + ' of *' );
                tc_brc.loading( true );

                // Start deleting
                tc_brc.process_delete();
            }
        }
    });

    var tc_brc = {

        loading: function( loading ) {

            switch ( loading ) {
                case true:
                    $('.tccrr-loader').css( { 'display': 'inline-block' } );
                    break;

                default:
                    $('.tccrr-loader').css( { 'display': 'none' } );
            }
        },

        process_delete: async function( page, deleted ) {

            page = ( typeof page !== 'undefined' ) ? page : 1;
            deleted = ( typeof deleted !== 'undefined' ) ? deleted : 0;

            await $.post( tc_bulk_remove_checkins.ajaxUrl, {
                action: 'tc_bulk_remove_checkins',
                event_ids: $('#tc_bulk_remove_checkins_event_filter select').chosen().val(),
                date_from: $( 'input[name="tickets_created_date_range_from"]' ).val(),
                date_to: $( 'input[name="tickets_created_date_range_to"]' ).val(),
                page: page,
                deleted: deleted

            }, function ( response ) {

                if ( typeof response !== 'undefined') {

                    if ( ! response.completed ) {
                        $( '.tc_bulk_delete_checkins_notice' ).removeClass( 'tc-dl-error' ).addClass( 'tc-dl-notice' ).html( response.deleted + ' ' + tc_bulk_remove_checkins.has_been_removed + '<br>' + response.page + ' of ' + response.max_page );
                        tc_brc.process_delete( response.page, response.deleted );

                    } else {

                        // Process completed
                        $( '.tc_bulk_delete_checkins_notice' ).removeClass( 'tc-dl-error' ).addClass( 'tc-dl-notice' ).html( response.deleted + ' ' + tc_bulk_remove_checkins.has_been_removed + '<br>' + ( response.page - 1 ) + ' of ' + response.max_page + ' (Completed)' );

                        tc_brc.loading( false );
                        $( '#tc_bulk_remove_checkins_btn' ).prop( 'disabled', false );
                    }

                } else {
                    $( '.tc_bulk_delete_checkins_notice' ).removeClass( 'tc-dl-notice' ).addClass( 'tc-dl-error' ).html( tc_bulk_remove_checkins.has_error );
                }
            });
        }
    };

})( jQuery );
