<?php
/**
 * Plugin Name: Checkin App - Show Seat Number
 * Plugin URI: http://tickera.com/
 * Description: Show seat number field in the check-in app.
 * Author: Tickera.com
 * Author URI: http://tickera.com/
 * Version: 1.1
 * TextDomain: tc
 * Domain Path: /languages/
 * Copyright 2018 Tickera (http://tickera.com/)
 */

if ( !defined( 'ABSPATH' ) )
    exit; // Exit if accessed directly

if ( !class_exists( 'TC_Checkin_App_Show_Seat_Number' ) ) {

    class TC_Checkin_App_Show_Seat_Number
    {

        var $version = '1.1';
        var $title = 'Checkin App - Show Seat Number';
        var $name = 'show-separate-seat-number-in-check-in';
        var $dir_name = 'show-separate-seat-number-in-check-in';
        var $location = 'plugins';
        var $plugin_dir = '';
        var $plugin_url = '';

        function __construct() {
            $this->init_vars();
            add_action( 'activated_plugin', array( $this, 'plugin_dependencies' ), 99 );
            add_filter( 'tc_checkin_custom_fields', array( $this, 'add_checkin_custom_fields_bridge_seats' ), 10, 5 );
        }

        function init_vars() {

            if ( defined( 'WP_PLUGIN_URL' ) && defined( 'WP_PLUGIN_DIR' ) && file_exists( WP_PLUGIN_DIR . '/' . $this->dir_name . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'subfolder-plugins';
                $this->plugin_dir = WP_PLUGIN_DIR . '/' . $this->dir_name . '/';
                $this->plugin_url = plugins_url( '/', __FILE__ );

            } elseif ( defined( 'WP_PLUGIN_URL' ) && defined( 'WP_PLUGIN_DIR' ) && file_exists( WP_PLUGIN_DIR . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'plugins';
                $this->plugin_dir = WP_PLUGIN_DIR . '/';
                $this->plugin_url = plugins_url( '/', __FILE__ );

            } else if ( is_multisite() && defined( 'WPMU_PLUGIN_URL' ) && defined( 'WPMU_PLUGIN_DIR' ) && file_exists( WPMU_PLUGIN_DIR . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'mu-plugins';
                $this->plugin_dir = WPMU_PLUGIN_DIR;
                $this->plugin_url = WPMU_PLUGIN_URL;

            } else {
                wp_die( sprintf( __( 'There was an issue determining where %s is installed. Please reinstall it.', 'tc' ), $this->title ) );
            }
        }

        /**
         * Load this plugin the very last to ensure all the dependencies loaded first.
         */
        function plugin_dependencies() {

            $plugin_slug = basename( __DIR__ ) . '/' . basename( __FILE__ );
            $active_plugins = get_option( 'active_plugins', [] );
            $index = array_search( $plugin_slug, $active_plugins );

            if ( $index !== false ) {
                unset( $active_plugins[ $index ] );
                $active_plugins[] = $plugin_slug;
                update_option( 'active_plugins', array_values( $active_plugins ) );
            }
        }

        function add_checkin_custom_fields_bridge_seats( $custom_fields, $ticket_instance_id, $event_id, $order, $ticket_type ) {

            $custom_field_value = get_post_meta( $ticket_instance_id, 'seat_label', true );

            if ( isset( $custom_field_value ) && !empty( $custom_field_value ) && !is_null( $custom_field_value ) ) {
                $custom_fields[] = array( 'Seat Number', $custom_field_value );
            }

            return $custom_fields;
        }
    }

    $TC_Checkin_App_Show_Seat_Number = new TC_Checkin_App_Show_Seat_Number();
}
