<?php

namespace Tickera\Ticket\Element;

if ( ! defined( 'ABSPATH' ) )
    exit; // Exit if accessed directly

if ( class_exists( '\Tickera\TC_Ticket_Template_Elements' ) ) {

    class tc_event_organizer_element extends \Tickera\TC_Ticket_Template_Elements {

        var $element_name = 'tc_event_organizer_element';
        var $element_title = 'Event Organizer';
        var $font_awesome_icon = '<i class="fa fa-user"></i>';

        function on_creation() {
            $this->element_title = apply_filters( 'tc_event_organizer_element_title', __( 'Event Organizer', 'tc' ) );
        }

        function ticket_content( $ticket_instance_id = false, $ticket_type_id = false ) {
            if ( $ticket_instance_id ) {
                $ticket_instance = new \Tickera\TC_Ticket( (int)$ticket_instance_id );
                $ticket = new \Tickera\TC_Ticket();
                $event_id = $ticket->get_ticket_event( apply_filters( 'tc_ticket_type_id', $ticket_instance->details->ticket_type_id ) );
                $organizer_label = get_post_meta( $event_id, 'tc_organizer_label', true );
                $organizer_name = get_post_meta( $event_id, 'tc_organizer_name', true );
                $organizer_address_1 = get_post_meta( $event_id, 'tc_organizer_address_1', true );
                $organizer_address_2 = get_post_meta( $event_id, 'tc_organizer_address_2', true );
                $organizer_zip = get_post_meta( $event_id, 'tc_organizer_zip', true );
                $organizer_city = get_post_meta( $event_id, 'tc_organizer_city', true );


                if ( !empty( $organizer_label ) ) {
                    return $organizer_label . '<br/>' . $organizer_name . '<br/>' . $organizer_address_1 . '<br/>' . $organizer_address_2 . '<br/>' . $organizer_zip . ' ' . $organizer_city;
                } else {

                    return 'Event organizer details:<br/>' . $organizer_name . '<br/>' . $organizer_address_1 . '<br/>' . $organizer_address_2 . '<br/>' . $organizer_zip . ' ' . $organizer_city;
                }
            }
        }

    }

    \Tickera\tickera_register_template_element( 'Tickera\Ticket\Element\tc_event_organizer_element', __( 'Event Organizer', 'tc' ) );
}