<?php
/**
 * Plugin Name: Tickera - Event Organizer Details
 * Plugin URI: http://tickera.com/
 * Description: Adds new fields for the event organizer details. Display these fields with shortcode [tc_organizer_details id="123"] (123 should be the ID the event) or on the ticket itself with the included ticket template element.
 * Author: Tickera.com
 * Author URI: http://tickera.com/
 * Version: 1.2
 * TextDomain: tc
 * Domain Path: /languages/
 * Copyright 2021 Tickera (http://tickera.com/)
 */
if ( ! defined( 'ABSPATH' ) )
    exit; // Exit if accessed directly

/**
 * Add custom fields
 */
add_filter( 'tc_event_fields', 'tc_organizer_label', 10, 1 );
add_filter( 'tc_event_fields', 'tc_organizer_name', 10, 1 );
add_filter( 'tc_event_fields', 'tc_organizer_address_1', 10, 1 );
add_filter( 'tc_event_fields', 'tc_organizer_address_2', 10, 1 );
add_filter( 'tc_event_fields', 'tc_organizer_zip', 10, 1 );
add_filter( 'tc_event_fields', 'tc_organizer_city', 10, 1 );

function tc_organizer_label( $fields ) {
    $fields[] = array(
        'field_name' => 'tc_organizer_label',
        'field_title' => __( 'Organizer label', 'tc' ),
        'field_type' => 'text',
        'tooltip' => __( 'The label that will be used when displaying the details. Eg. <i>Event organizer details</i><br/>If left blank, it will display default <i>Event organizer details:</i> label', 'tc' ),
        'table_visibility' => true,
        'post_field_type' => 'post_meta'
    );

    return $fields;
}

function tc_organizer_name( $fields ) {
    $fields[] = array(
        'field_name' => 'tc_organizer_name',
        'field_title' => __( 'Event organizer name', 'tc' ),
        'field_type' => 'text',
        'tooltip' => __( 'The name of the event organizer/company', 'tc' ),
        'table_visibility' => true,
        'post_field_type' => 'post_meta'
    );

    return $fields;
}


function tc_organizer_address_1( $fields ) {
    $fields[] = array(
        'field_name' => 'tc_organizer_address_1',
        'field_title' => __( 'Event organizer address 1', 'tc' ),
        'field_type' => 'text',
        'tooltip' => __( 'Event organizer address field 1', 'tc' ),
        'table_visibility' => true,
        'post_field_type' => 'post_meta'
    );

    return $fields;
}


function tc_organizer_address_2( $fields ) {
    $fields[] = array(
        'field_name' => 'tc_organizer_address_2',
        'field_title' => __( 'Event organizer address 2', 'tc' ),
        'field_type' => 'text',
        'tooltip' => __( 'Event organizer address field 2', 'tc' ),
        'table_visibility' => true,
        'post_field_type' => 'post_meta'
    );

    return $fields;
}


function tc_organizer_zip( $fields ) {
    $fields[] = array(
        'field_name' => 'tc_organizer_zip',
        'field_title' => __( 'Event organizer ZIP', 'tc' ),
        'field_type' => 'text',
        'tooltip' => __( 'Event organizer ZIP code', 'tc' ),
        'table_visibility' => true,
        'post_field_type' => 'post_meta'
    );

    return $fields;
}


function tc_organizer_city( $fields ) {
    $fields[] = array(
        'field_name' => 'tc_organizer_city',
        'field_title' => __( 'Event organizer city', 'tc' ),
        'field_type' => 'text',
        'tooltip' => __( 'Event organizer city', 'tc' ),
        'table_visibility' => true,
        'post_field_type' => 'post_meta'
    );

    return $fields;
}


/**
 * Custom fields shortcode callback
 */
add_shortcode( 'tc_organizer_details', 'tc_organizer_details' );
function tc_organizer_details( $atts ) {
    extract( shortcode_atts( array(
        'id' => ''
    ), $atts ) );

    if ( !empty( $id ) ) {
        $organizer_label = get_post_meta( $id, 'tc_organizer_label', true );
        $organizer_name = get_post_meta( $id, 'tc_organizer_name', true );
        $organizer_address_1 = get_post_meta( $id, 'tc_organizer_address_1', true );
        $organizer_address_2 = get_post_meta( $id, 'tc_organizer_address_2', true );
        $organizer_zip = get_post_meta( $id, 'tc_organizer_zip', true );
        $organizer_city = get_post_meta( $id, 'tc_organizer_city', true );

    } else {
        $organizer_label = get_post_meta( get_the_ID(), 'tc_organizer_label', true );
        $organizer_name = get_post_meta( get_the_ID(), 'tc_organizer_name', true );
        $organizer_address_1 = get_post_meta( get_the_ID(), 'tc_organizer_address_1', true );
        $organizer_address_2 = get_post_meta( get_the_ID(), 'tc_organizer_address_2', true );
        $organizer_zip = get_post_meta( get_the_ID(), 'tc_organizer_zip', true );
        $organizer_city = get_post_meta( get_the_ID(), 'tc_organizer_city', true );
    }

    if ( !empty( $organizer_label ) ) {
        return '<strong>' . $organizer_label . '</strong><br/>' . $organizer_name . '<br/>' . $organizer_address_1 . '<br/>' . $organizer_address_2 . '<br/>' . $organizer_zip . '<br/>' . $organizer_city;

    } else {
        return '<strong>Event organizer details:</strong><br/>' . $organizer_name . '<br/>' . $organizer_address_1 . '<br/>' . $organizer_address_2 . '<br/>' . $organizer_zip . '<br/>' . $organizer_city;
    }
}

if ( !class_exists( 'TC_event_organizer_details_ticket_template_element' ) ) {

    class TC_event_organizer_details_ticket_template_element {

        var $version = '1.2';
        var $title = 'Event Organizer Ticket Template Element';
        var $name = 'event-organizer-ticket-template-element';
        var $dir_name = 'event-organizer-fields';
        var $location = 'plugins';
        var $plugin_dir = '';
        var $plugin_url = '';

        function __construct() {
            $this->init_vars();
            add_action( 'activated_plugin', array( $this, 'plugin_dependencies' ), 99 );
            add_action( 'tc_load_ticket_template_elements', array( $this, 'load_ticket_template_elements' ) );
        }

        function init_vars() {

            if ( defined( 'WP_PLUGIN_URL' ) && defined( 'WP_PLUGIN_DIR' ) && file_exists( WP_PLUGIN_DIR . '/' . $this->dir_name . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'subfolder-plugins';
                $this->plugin_dir = WP_PLUGIN_DIR . '/' . $this->dir_name . '/';
                $this->plugin_url = plugins_url( '/', __FILE__ );

            } elseif ( defined( 'WP_PLUGIN_URL' ) && defined( 'WP_PLUGIN_DIR' ) && file_exists( WP_PLUGIN_DIR . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'plugins';
                $this->plugin_dir = WP_PLUGIN_DIR . '/';
                $this->plugin_url = plugins_url( '/', __FILE__ );

            } elseif ( is_multisite() && defined( 'WPMU_PLUGIN_URL' ) && defined( 'WPMU_PLUGIN_DIR' ) && file_exists( WPMU_PLUGIN_DIR . '/' . basename( __FILE__ ) ) ) {
                $this->location = 'mu-plugins';
                $this->plugin_dir = WPMU_PLUGIN_DIR;
                $this->plugin_url = WPMU_PLUGIN_URL;

            } else {
                wp_die( sprintf( __( 'There was an issue determining where %s is installed. Please reinstall it.', 'tc' ), $this->title ) );
            }
        }

        /**
         * Load this plugin the very last to ensure all the dependencies loaded first.
         */
        function plugin_dependencies() {

            $plugin_slug = basename( __DIR__ ) . '/' . basename( __FILE__ );
            $active_plugins = get_option( 'active_plugins', [] );
            $index = array_search( $plugin_slug, $active_plugins );

            if ( $index !== false ) {
                unset( $active_plugins[ $index ] );
                $active_plugins[] = $plugin_slug;
                update_option( 'active_plugins', array_values( $active_plugins ) );
            }
        }

        function load_ticket_template_elements() {
            include_once $this->plugin_dir . 'ticket-elements/event-organizer-element.php';
            do_action( 'tc_load_event_organizer_details_ticket_template_element' );
        }
    }
}

$TC_event_organizer_details_ticket_template_element = new TC_event_organizer_details_ticket_template_element();