<?php
/**
 * Plugin Name: YTD stats dashboard widget for Tickera
 * Plugin URI: http://tickera.com/
 * Description: Shows year-to-date stats for Tickera
 * Author: Tickera.com
 * Author URI: http://tickera.com/
 * Version: 1.1
 * TextDomain: tc
 * Domain Path: /languages/
 * Copyright 2017 Tickera (http://tickera.com/)
 */
if ( !defined( 'ABSPATH' ) )
    exit; // Exit if accessed directly

add_action( 'activated_plugin', function () {

    $plugin_slug = basename( __DIR__ ) . '/' . basename( __FILE__ );
    $active_plugins = get_option( 'active_plugins', [] );
    $index = array_search( $plugin_slug, $active_plugins );

    if ( $index !== false ) {
        unset( $active_plugins[ $index ] );
        $active_plugins[] = $plugin_slug;
        update_option( 'active_plugins', array_values( $active_plugins ) );
    }

}, 99 );

add_action( 'plugins_loaded', function() {
    include( plugin_dir_path( __FILE__ ) . '/stats-dashboard-widget/index.php' );
} );