<?php
/**
 * Plugin Name: Tickera - Custom Ticket PDF filename
 * Plugin URI: http://tickera.com/
 * Description: Change the filename of the downloaded PDF ticket
 * Author: Tickera.com
 * Author URI: http://tickera.com/
 * Version: 1.1
 * Copyright 2021 Tickera (http://tickera.com/)
 */
if ( !defined( 'ABSPATH' ) )
    exit; // Exit if accessed directly

add_action( 'activated_plugin', function() {
    $plugin_slug = basename( __DIR__ ) . '/' . basename( __FILE__ );
    $active_plugins = get_option( 'active_plugins', [] );
    $index = array_search( $plugin_slug, $active_plugins );

    if ( $index !== false ) {
        unset( $active_plugins[ $index ] );
        $active_plugins[] = $plugin_slug;
        update_option( 'active_plugins', array_values( $active_plugins ) );
    }
}, 99 );

/**
 * Add option
 */
add_filter( 'tc_general_settings_miscellaneous_fields', 'tc_general_settings_miscellaneous_fields_set_custom_pdf_title' );
function tc_general_settings_miscellaneous_fields_set_custom_pdf_title( $fields ) {
    $fields [] = array(
        'field_name' => 'tc_custom_pdf_title',
        'field_title' => __( 'Set custom PDF filename for downloaded tickets', 'tc' ),
        'field_type' => 'option',
        'default_value' => '',
        'tooltip' => 'Set the custom filename for tickets when downloaded as PDF. If left blank, the filename will contain the event title followed by ticket code',
        'section' => 'miscellaneous_settings',
    );
    return $fields;
}

/**
 * Handle
 */
add_filter( 'tc_pdf_ticket_name', 'tc_change_ticket_name', 10, 2 );
function tc_change_ticket_name( $ticket_code, $ticket_instance ) {

    $tc_get_option = get_option( 'tickera_general_setting', false );
    $tc_custom_pdf_title = isset( $tc_get_option[ 'tc_custom_pdf_title' ] ) ? $tc_get_option[ 'tc_custom_pdf_title' ] : '';

    $ticket_type = new Tickera\TC_Ticket( $ticket_instance->details->ticket_type_id );
    $ticket_event_id = $ticket_type->get_ticket_event( $ticket_instance->details->ticket_type_id );
    $tc_event_title = get_the_title( $ticket_event_id );

    if ( !empty ( $tc_custom_pdf_title ) ) {
        return $tc_custom_pdf_title . '-' . $ticket_code;

    } else {
        return $tc_event_title . '-' . $ticket_code;
    }
}