<?php
/**
 * Plugin Name: Tickera - API Keys check-ins count
 * Plugin URI: http://tickera.com/
 * Description: Adds check-ins count column to the API Key settings
 * Author: Tickera.com
 * Author URI: http://tickera.com/
 * Version: 1.1
 * TextDomain: tc
 * Domain Path: /languages/
 * Copyright 2016 Tickera (http://tickera.com/)
 */

if ( !defined( 'ABSPATH' ) )
    exit; // Exit if accessed directly

add_action( 'activated_plugin', function () {

    $plugin_slug = basename( __DIR__ ) . '/' . basename( __FILE__ );
    $active_plugins = get_option( 'active_plugins', [] );
    $index = array_search( $plugin_slug, $active_plugins );

    if ( $index !== false ) {
        unset( $active_plugins[ $index ] );
        $active_plugins[] = $plugin_slug;
        update_option( 'active_plugins', array_values( $active_plugins ) );
    }

}, 99 );

add_filter( 'tc_api_keys_fields', 'tc_api_keys_fields_add_extra_column_checkins_count' );
function tc_api_keys_fields_add_extra_column_checkins_count( $fields ) {
    $fields[] = array(
        'field_name' => 'check_ins_count',
        'field_title' => __( 'Check-ins Count', 'tc' ),
        'field_type' => 'function',
        'function' => 'tc_get_checkins_count',
        'field_description' => '',
        'table_visibility' => true,
        'post_field_type' => 'post_meta'
    );
    return $fields;
}

function tc_get_checkins_count( $field_name = '', $post_id = '' ) {
    return;
}

add_filter( 'tc_api_key_field_value', 'tc_api_key_field_value_add_extra_column_checkins_count', 10, 3 );
function tc_api_key_field_value_add_extra_column_checkins_count( $value, $post_field_type, $var_name ) {

    global $api_id, $wpdb;

    if ( $var_name == 'ID' ) {
        $api_id = $value;
    }

    if ( $var_name == 'check_ins_count' ) {
        $check_ins = $wpdb->get_results( 'SELECT * FROM ' . $wpdb->postmeta . ' WHERE meta_key = "tc_checkins" AND meta_value LIKE "%\"api_key_id\";i:' . (int)$api_id . ';%"', OBJECT );
        return count( $check_ins );
    }

    return $value;
}
