<?php
global $tc;

if ( !defined( 'ABSPATH' ) ) {
    exit;
}

if ( isset( $_POST[ 'tc_reassociate_event_ids' ] ) && current_user_can( 'manage_options' ) ) {
    if ( isset( $_POST[ 'tc_event_ids' ] ) && isset( $_POST[ 'tc_ticket_type_ids' ] ) ) {

        ini_set( 'max_input_time', 0 );
        ini_set( 'max_execution_time', 0 );
        set_time_limit( 0 );
        @ini_set( 'memory_limit', '1024M' );


        $args = array(
            'posts_per_page' => -1,
            'post_type' => 'tc_tickets_instances',
            'meta_key' => 'ticket_type_id',
            'meta_value' => $_POST[ 'tc_ticket_type_ids' ],
            'post_status' => 'any'
        );

        $ticket_instances = get_posts( $args );

        foreach ( $ticket_instances as $ticket_instance ) {
            update_post_meta( $ticket_instance->ID, 'event_id', $_POST[ 'tc_event_ids' ] );
        }

        $message = __( 'All attendee records have been associated with the selected event.', 'tc' );
    }
}
?>
<div class="wrap tc_wrap" id="tc_delete_info">
    <?php if ( isset( $message ) ) { ?>
        <div id="message" class="updated fade"><p><?php echo $message; ?></p></div>
    <?php } ?>
    <div id="poststuff" class="metabox-holder tc-settings">
        <form id="tc-delete-info" method='post' action='<?php echo esc_attr( admin_url( 'edit.php?post_type=tc_events&page=tc_settings&tab=reassociate_event_ids' ) ); ?>'>
            <div class="postbox">
                <h3><span><?php _e( 'Reassociate existing tickets with correct events', 'tc' ); ?></span></h3>
                <div class="inside">
                    <span class="description"></span>
                    <table class="form-table" cellspacing="0" id="status">
                        <tbody>
                        <tr>
                            <th><?php _e( 'Event', 'tc' ); ?></th>
                            <th><?php _e( 'Product / Ticket Type', 'tc' ); ?></th>
                        </tr>
                        <tr>
                            <td><?php
                                $ticket_types_ids = array();
                                $arg = array(
                                    'posts_per_page' => -1,
                                    'post_type' => 'tc_events',
                                    'suppress_filters' => true
                                );
                                $events = get_posts( $arg );
                                ?>
                                <select name="tc_event_ids">
                                    <?php
                                    foreach ( $events as $event_single ) {
                                        $tc_event = new \Tickera\TC_Event( $event_single->ID );
                                        $ticket_types_ids = array_merge( $ticket_types_ids, $tc_event->get_event_ticket_types( 'any', $event_single->ID ) ); ?>
                                        <option value="<?php echo $event_single->ID; ?>"><?php echo $event_single->post_title; ?></option>
                                        <?php
                                    }
                                    ?>
                                </select>
                            </td>
                            <td>
                                <select name="tc_ticket_type_ids">
                                    <?php foreach ( $ticket_types_ids as $ticket_type_id ) {
                                        $ticket_type = new \Tickera\TC_Ticket( (int)$ticket_type_id ); ?>
                                        <option value="<?php echo $ticket_type_id; ?>"><?php echo apply_filters( 'tc_checkout_owner_info_ticket_title', $ticket_type->details->post_title, $ticket_type_id, array(), 0 ); ?></option>
                                    <?php } ?>
                                </select>
                            </td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php submit_button( __( 'Reassociate Records', 'tc' ), 'primary', 'tc_reassociate_event_ids', true ); ?>
        </form>
    </div>
</div>