<?php
/**
 * Plugin Name: Tickera - Reassociate Tickets
 * Plugin URI: https://tickera.com/
 * Description: Reassociate existing ticket instances with a different event. 
 * Author: Tickera.com
 * Author URI: https://tickera.com/
 * Version: 1.2
 * Copyright 2018 Tickera (https://tickera.com/)
 */

if ( !defined( 'ABSPATH' ) )
    exit; // Exit if accessed directly

if ( !is_admin() ) {
    return;
}

if ( !class_exists( 'TC_Reassociate_Event_Ids' ) ) {

    class TC_Reassociate_Event_Ids {

        var $version = '1.2';
        var $title = 'Reassociate tickets';
        var $name = 'tc';
        var $dir_name = 'change-event-ids';
        var $plugin_dir = '';
        var $plugin_url = '';

        function __construct() {
            $this->title = __( 'Reassociate tickets', 'tc' );
            add_action( 'activated_plugin', array( $this, 'plugin_dependencies' ), 99 );
            add_filter( 'tc_settings_new_menus', array( &$this, 'tc_settings_new_menus_additional' ) );
            add_action( 'tc_settings_menu_reassociate_event_ids', array( &$this, 'tc_settings_menu_tickera_reassociate_event_ids_page' ) );
        }

        function tc_settings_new_menus_additional( $settings_tabs ) {
            $settings_tabs[ 'reassociate_event_ids' ] = __( 'Reassociate tickets', 'tc' );
            return $settings_tabs;
        }

        function tc_settings_menu_tickera_reassociate_event_ids_page() {
            require_once( plugin_dir_path( __FILE__ ) . 'reassociate_event_ids_page.php' );
        }

        /**
         * Load this plugin the very last to ensure all the dependencies loaded first.
         */
        function plugin_dependencies() {

            $plugin_slug = basename( __DIR__ ) . '/' . basename( __FILE__ );
            $active_plugins = get_option( 'active_plugins', [] );
            $index = array_search( $plugin_slug, $active_plugins );

            if ( $index !== false ) {
                unset( $active_plugins[ $index ] );
                $active_plugins[] = $plugin_slug;
                update_option( 'active_plugins', array_values( $active_plugins ) );
            }
        }
    }

    $TC_Reassociate_Event_Ids = new TC_Reassociate_Event_Ids();
}